<?php
/**
 * Shipping zones meta box.
 *
 * Shipping zones meta box to select the zone.
 *
 * @author     	Jeroen Sormani
 * @package		WooCommerce Advanced Shipping Zones
 * @version		1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $post;

$countries 	= WC()->countries->get_allowed_countries();
$states 	= WC()->countries->states;

$selected_countries = (array) get_post_meta( $post->ID, '_countries', true );
$selected_states	= (array) get_post_meta( $post->ID, '_states', true );
$zipcode_value		= get_post_meta( $post->ID, '_zipcodes', true );

wp_nonce_field( 'shipping_zones_meta_box', 'shipping_zones_meta_box_nonce' );
?>

<div class='zone_desc'><?php
	_e( 'This shipping zone can be used to select as a value while using the \'Shipping Zone\' condition.<br/> If a user matches <u class="help_tip" data-tip="Example: If you enter a zipcode and country, the zipcode will match separately from the country. This means that a user from another country with the same zipcode will match this zone.">ANY</u> of the entered values, the condition will match.', 'woocommerce-advanced-shipping' );
?></div>


<table class="widefat zone-table">
	<tbody>

		<tr><!-- Countries -->
			<td class="label">
				<label for='countries'><?php _e( 'Countries', 'woocommerce-advanced-shipping' ); ?></label>
				<span class='description'>
					<img class='help_tip' src='<?php echo WC()->plugin_url(); ?>/assets/images/help.png' height='16' width='16' data-tip="<?php _e( 'Select one or more countries. If user matches any selected countries, the condition will match.', 'woocommerce-advanced-shipping' ); ?>" />
				</span>
			</td>
			<td>
				<select name='countries[]' multiple='multiple' id='countries' class='wc-enhanced-select'><?php
					foreach ( $countries as $key => $country ) :
						?><option <?php selected( in_array( $key, $selected_countries ) ); ?> value='<?php echo $key; ?>'><?php echo $country; ?></option><?php
					endforeach;
				?></select>
			</td>
		</tr>


		<tr><!-- States -->
			<td class="label">
				<label for='states'><?php _e( 'States', 'woocommerce-advanced-shipping' ); ?></label>
				<span class='description'>
					<img class='help_tip' src='<?php echo WC()->plugin_url(); ?>/assets/images/help.png' height='16' width='16' data-tip="<?php _e( 'Select one or more states. If user matches any selected states, the condition will match.', 'woocommerce-advanced-shipping' ); ?>" />
				</span>
			</td>
			<td>

				<select name='states[]' id='states' multiple='multiple' class='wc-enhanced-select'><?php

					foreach ( $states as $country => $states ) :

						if ( empty( $states ) ) continue; // Don't show country if it has no states
						if ( ! array_key_exists( $country, $countries ) ) continue; // Skip unallowed countries

						?><optgroup label='<?php echo $countries[ $country ]; ?>'><?php

							foreach ( $states as $state_key => $state ) :
								?><option <?php selected( in_array( $country . '_' . $state_key, $selected_states ) ); ?> value='<?php echo $country . '_' . $state_key; ?>'><?php
									echo $state;
								?></option><?php
							endforeach;

						?></optgroup><?php

					endforeach;

				?></select>

			</td>
		</tr>


		<tr><!-- Zipcodes -->
			<td class="label">
				<label for='zipcodes'><?php _e( 'Zipcodes', 'woocommerce-advanced-shipping' ); ?></label>
				<span class='description'>
					<img class='help_tip' src='<?php echo WC()->plugin_url(); ?>/assets/images/help.png' height='16' width='16' data-tip="<?php _e( 'Separate zipcodes by comma (,) or a new line. <br/>Use ranges by separating two values by a dash (-).', 'woocommerce-advanced-shipping' ); ?>" />
				</span>
			</td>
			<td>
				<textarea name='zipcodes' id="zipcodes" class='' placeholder='<?php _e( 'Zipcodes', 'woocommerce-advanced-shipping' ); ?>'><?php echo $zipcode_value; ?></textarea>
			</td>
		</tr>

	</tbody>
</table>
