<?PHP
/*
 * Plugin Name: WooCommerce Advanced Shipping Zones
 * Plugin URI: https://jeroensormani.com/
 * Description: WooCommerce Advanced Shipping Zones is an extension to add Shipping Zones to WooCommerce Advanced Shipping
 * Version: 1.1.4
 * Author: Jeroen Sormani
 * Author URI: https://jeroensormani.com/
 * Text Domain: woocommerce-advanced-shipping-zones
 *
 * WC requires at least: 5.0
 * WC tested up to: 8.6
 */

/**
 * Copyright Jeroen Sormani
 *	Class WooCommerce_Advanced_Shipping_Zones
 *
 *	Main WAS class, add filters and handling all other files
 *
 *	@class       WooCommerce_Advanced_Shipping_Zones
 *	@version     1.0.0
 *	@author      Jeroen Sormani
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class WooCommerce_Advanced_Shipping_Zones {


	/**
	 * Instance of Advanced_Payment_Methods_WooCommerce.
	 *
	 * @since 1.0.1
	 * @access private
	 * @var object $instance The instance of WASZ.
	 */
	private static $instance;

	/**
	 * @var WASZ_Settings
	 */
	public $settings;

	/**
	 * @var WASZ_Post_Type
	 */
	public $post_type;


	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {

		// Enqueue scripts
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );

		// Shipping Zones condition
		require_once 'includes/class-was-condition-shipping-zone.php';
		new WAS_Condition_Shipping_Zone();

		// Settings page
		require_once 'includes/class-wasz-settings.php';
		$this->settings = new WASZ_Settings();

		// Post type
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-wasz-post-type.php';
		$this->post_type = new WASZ_Post_Type();

		// Add to WC Screen IDs to load scripts.
		add_filter( 'woocommerce_screen_ids', array( $this, 'add_wc_screen_ids' ) );

		// Declare HPOS compatibility
		add_action( 'before_woocommerce_init', function () {
			if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
				\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
			}
		} );
	}


	/**
	 * Instance.
	 *
	 * An global instance of the class. Used to retrieve the instance
	 * to use on other files/plugins/themes.
	 *
	 * @since 1.0.1
	 *
	 * @return object Instance of the class.
	 */
	public static function instance() {

		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;

	}


	/**
	 * Enqueue scripts.
	 *
	 * Enqueue style and java scripts.
	 *
	 * @since 1.0.0
	 */
	public function admin_enqueue_scripts() {

		// Only load scripts on relevant pages
		if (
			( isset( $_REQUEST['post'] ) && 'shipping_zone' == get_post_type( $_REQUEST['post'] ) ) ||
			( isset( $_REQUEST['post_type'] ) && 'shipping_zone' == $_REQUEST['post_type'] ) ||
			( isset( $_REQUEST['tab'] ) && 'shipping_zones' == $_REQUEST['tab'] )
		) {

			// Style script
			wp_enqueue_style( 'woocommerce-advanced-shipping-zones', plugins_url( 'assets/css/woocommerce-advanced-shipping-zones.css', __FILE__ ), array() );

		}

	}


	/**
	 * Screen IDs.
	 *
	 * Add 'was' to the screen IDs so the WooCommerce scripts are loaded.
	 *
	 * @since 1.1.0
	 *
	 * @param  array $screen_ids List of existing screen IDs.
	 * @return array             List of modified screen IDs.
	 */
	public function add_wc_screen_ids( $screen_ids ) {

		$screen_ids[] = 'shipping_zone';

		return $screen_ids;

	}


}


/**
 * The main function responsible for returning the WooCommerce_Advanced_Shipping_Zones object.
 *
 * Use this function like you would a global variable, except without needing to declare the global.
 *
 * Example: <?php WASZ()->method_name(); ?>
 *
 * @since 1.0.1
 *
 * @return object WooCommerce_Advanced_Shipping_Zones class object.
 */
if ( ! function_exists( 'WASZ' ) ) {

 	function WASZ() {
		return WooCommerce_Advanced_Shipping_Zones::instance();
	}

}

add_action( 'woocommerce_advanced_shipping_init', 'WASZ' );
