<?php
/**
 * Plugin Name: 	WooCommerce Advanced Shipping - Advanced Pricing
 * Plugin URI: 		http://jeroensormani.com/
 * Description: 	WooCommerce Advanced Shipping - Advanced Pricing is a extension for <strong>WooCommerce Advanced Shipping</strong> to allow more advanced pricing.
 * Version: 		2.3.1
 * Author: 			Jeroen Sormani
 * Author URI: 		http://jeroensormani.com/
 * Text Domain: 	woocommerce-advanced-shipping-advanced-pricing
 * WC requires at least: 8.0
 * WC tested up to:      9.3
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Class WooCommerce_Advanced_Shipping_Advanced_Pricing.
 *
 * Main class, add filters and handling all other files.
 *
 * @class		WooCommerce_Advanced_Shipping_Advanced_Pricing
 * @version		1.0.0
 * @author		Jeroen Sormani
 */
class WooCommerce_Advanced_Shipping_Advanced_Pricing {

	/** @var string $version Plugin version number. */
	public $version = '2.3.1';

	/** @var string Plugin file path. */
	public $file = __FILE__;

	/** @var WASAP_Price_Settings Price settings class. */
	public $price_settings;

	/** @var WASAP_Price_Settings Admin class. */
	public $admin;

	/**
	 * Instance of WooCommerce_Advanced_Shipping_Advanced_Pricing.
	 *
	 * @since 1.0.1
	 * @access private
	 * @var object $instance The instance of WAS.
	 */
	private static $instance;


	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {

		// Functions
		require_once plugin_dir_path( __FILE__ ) . 'includes/wasap-core-functions.php';

		// Price settings
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-wasap-price-settings.php';
		$this->price_settings = new WASAP_Price_Settings();

		if ( is_admin() ) {
			require plugin_dir_path( __FILE__ ) . 'includes/admin/class-wasap-admin.php';
			$this->admin = new WASAP_Admin();
		}

		// Enqueue scripts
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );

		// Declare HPOS compatibility
		add_action( 'before_woocommerce_init', function () {
			if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
				\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
			}
		} );
	}


	/**
	 * Instance.
	 *
	 * An global instance of the class. Used to retrieve the instance
	 * to use on other files/plugins/themes.
	 *
	 * @since 1.0.1
	 *
	 * @return object Instance of the class.
	 */
	public static function instance() {

		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;

	}


	/**
	 * Enqueue scripts.
	 *
	 * Enqueue style and java scripts.
	 *
	 * @since 1.0.0
	 */
	public function admin_enqueue_scripts() {

		// Only load scripts on relevant pages
		if (
			( isset( $_REQUEST['post'] ) && 'was' == get_post_type( $_REQUEST['post'] ) ) ||
			( isset( $_REQUEST['post_type'] ) && 'was' == $_REQUEST['post_type'] ) ||
			( isset( $_REQUEST['tab'] ) && 'shipping' == $_REQUEST['tab'] )
		) {

			// Style script
			wp_enqueue_style( 'woocommerce-advanced-shipping-advanced-pricing', plugins_url( 'assets/css/woocommerce-advanced-shipping-advanced-pricing.min.css', __FILE__ ), array() );

			// Javascript
			wp_enqueue_script( 'woocommerce-advanced-shipping-advanced-pricing', plugins_url( 'assets/js/woocommerce-advanced-shipping-advanced-pricing.min.js', __FILE__ ), array( 'jquery' ) );

		}
	}


}


/**
 * The main function responsible for returning the WooCommerce_Advanced_Shipping_Advanced_Pricing object.
 *
 * Use this function like you would a global variable, except without needing to declare the global.
 *
 * Example: <?php WooCommerce_Advanced_Shipping_Advanced_Pricing()->method_name(); ?>
 *
 * @since 1.1.0
 *
 * @return object WooCommerce_Advanced_Shipping_Advanced_Pricing class object.
 */
if ( ! function_exists( 'WooCommerce_Advanced_Shipping_Advanced_Pricing' ) ) {

	function WooCommerce_Advanced_Shipping_Advanced_Pricing() {
		return WooCommerce_Advanced_Shipping_Advanced_Pricing::instance();
	}
}
add_action( 'woocommerce_advanced_shipping_init', 'WooCommerce_Advanced_Shipping_Advanced_Pricing' );
