<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Advanced Pricing core functions.
 *
 * Core WAS Advanced Pricing functions used throughout the plugin.
 *
 * @author		Jeroen Sormani
 * @since		2.0.0
 */


/**
 * Apply shipping cost.
 *
 * Calculate and apply the extra advanced pricing cost.
 * This function calculated the percentage/cost per quantity etc.
 *
 * @since 2.0.0
 *
 * @param  float $cost           Shipping cost to add.
 * @param  int   $quantity       Quantity unit.
 * @param  float $group_subtotal Subtotal of the category / shipping class products.
 * @param  int   $min            The set minimum amount. Could be used to setup 'cost per additional item'.
 * @return float                 New fee amount.
 */
function wasap_apply_shipping_cost( $cost, $quantity = 1, $group_subtotal = 0.00, $min = null ) {

	$cart_subtotal = apply_filters( 'wasap_get_fee_amount_subtotal', ( WC()->cart->get_cart_contents_total() + WC()->cart->get_cart_contents_tax() ) );

	$raw_cost_amount = $cost;
	$cost            = str_replace( array( '-', '*', '%' ), '', $cost );
	$cost            = str_replace( ',', '.', $cost );
	$min             = absint( $min );

	// Group subtotal percentage
	if ( strstr( $raw_cost_amount, '%%' ) ) :
		$percent = str_replace( '%%', '', $cost );
		$cost    = ( ( $group_subtotal / 100 ) * $percent );

	// Cart subtotal percentage
	elseif ( strstr( $raw_cost_amount, '%' ) ) :
		$percent = str_replace( '%', '', $cost );
		$cost    = ( $cart_subtotal / 100 ) * $percent;
	endif;

	// Cost per additional item - EXPERIMENTAL (subject to change or even removal)
	if ( strstr( $raw_cost_amount, '**' ) ) :
		$additional_qty = $quantity - $min;
		$cost = $additional_qty * $cost;

	// Multiply
	elseif ( strstr( $raw_cost_amount, '*' ) ) :
		$cost = $cost * $quantity;
	endif;

	// 'per X' (rounding up) - EXPERIMENTAL (subject to change or even removal)
	if ( strstr( $raw_cost_amount, '/' ) ) :
		$per  = str_replace( '/', '', strstr( $cost, '/' ) );
		$cost = substr( $cost, 0, strpos( $cost, '/' ) ); // Get the cost before the '/'
		$cost = $cost * ceil( $quantity / $per );
	endif;

	// 'per X' (rounding down) - EXPERIMENTAL (subject to change or even removal)
	if ( strstr( $raw_cost_amount, '\\' ) ) :
		$per = str_replace( '\\', '', strstr( $cost, '\\' ) );
		$cost = substr( $cost, 0, strpos( $cost, '\\' ) );  // Get the cost before the '\'
		$cost = $cost * floor( $quantity / $per );
	endif;

	// Negative - Should be after all the other options
	if ( strstr( $raw_cost_amount, '-' ) ) :
		$cost = - $cost;
	endif;

	return apply_filters( 'wasap_apply_shipping_cost', $cost, $raw_cost_amount, $quantity, $group_subtotal );

}


if ( ! function_exists( 'is_was_page' ) ) {

	/**
	 * Current page WAS page?
	 *
	 * @since NEWVERSION
	 *
	 * @return bool True when the current page is related to Advanced Shipping, false otherwise.
	 */
	function is_was_page() {
		$return = false;

		if (
			( isset( $_REQUEST['post'] ) && 'was' == get_post_type( $_REQUEST['post'] ) ) ||
			( isset( $_REQUEST['post_type'] ) && 'was' == $_REQUEST['post_type'] ) ||
			( isset( $_REQUEST['section'] ) && 'legacy_advanced_shipping' == $_REQUEST['section'] )
		) {
			$return = true;
		}

		return $return;
	}
}
