jQuery( document ).ready( function( $ ) {

	// Advanced Cost
	$( '.wasap-tabbed-settings' ).on( 'click', '.tabs a', function() {

		if ( $( this ).data( 'target' ) !== undefined ) {

			// Tabs
			var tabs = $( this ).parents( '.tabs' );
			tabs.find( 'li' ).removeClass( 'active' );
			$( this ).parent( 'li' ).addClass( 'active' );

			// Panel
			var panels = tabs.parent().find( '.panels' );
			panels.find( '.panel' ).removeClass( 'active' ).hide();
			panels.find( '.panel#' + $( this ).data( 'target' ) ).addClass( 'active' ).show();

		}

	});

	// Delete repeater row
	$( '.wasap-tabbed-settings' ).on( 'click', '.delete-repeater-row', function() {
		$( this ).parents( '.repeater-row' ).slideUp( function() { $( this ).remove(); });
	});

	// Price input validation / error handling
	$( document.body ).on( 'blur', '.wasap_input_price[type=text]', function() {
		$( '.wc_error_tip' ).fadeOut( '100', function() { $( this ).remove(); } );
	})
	.on( 'keyup change', '.wasap_input_price[type=text]', function() {
		var value    = $( this ).val();
		var regex    = new RegExp( '[^0-9\\/\\-\\\\%\*\\' + woocommerce_admin.mon_decimal_point + ']+', 'gi' );
		var newvalue = value.replace( regex, '' );

		if ( value !== newvalue ) {
			$( this ).val( newvalue );
			$( document.body ).triggerHandler( 'wc_add_error_tip', [ $( this ), 'i18n_mon_decimal_error' ] );
		} else {
			$( document.body ).triggerHandler( 'wc_remove_error_tip', [ $( this ), 'i18n_mon_decimal_error' ] );
		}
	});

});